from Box2D import b2ContactListener, b2_pi
from Environment.Environments.Phyre.rendering import transform_vertices_for_render
from dataclasses import dataclass
import math
import numpy as np
import random


def is_point_inside_polygon(x, y, polygon):
    """
    Check if a point (x, y) is inside a polygon.

    Parameters:
    - x, y: Coordinates of the point.
    - polygon: List of (x, y) coordinates representing the vertices of the polygon.

    Returns:
    - True if the point is inside the polygon, False otherwise.
    """
    n = len(polygon)
    inside = False

    p1x, p1y = polygon[0]
    for i in range(n + 1):
        p2x, p2y = polygon[i % n]
        if min(p1y, p2y) < y <= max(p1y, p2y) and x <= max(p1x, p2x):
            if p1y != p2y:
                xinters = (y - p1y) * (p2x - p1x) / (p2y - p1y) + p1x
                if p1x == p2x or x <= xinters:
                    inside = not inside
        p1x, p1y = p2x, p2y

    return inside

def detect_success_basket(world, level, screen=None, tolerance=1):
    # Get the dimensions of the basket
    basket_height = 1.67 * level.objects["basket"].scale
    basket_width = 1.083 * level.objects["basket"].scale
    thickness = 0.075 * level.objects["basket"].scale
    angle_shift = math.cos(5 * b2_pi / 180) * 5

    # Get the target ball and basket from the world
    basket, target_object = None, None
    for body in world.bodies:
        if body.userData == level.target_object:
            target_object = body
        elif body.userData == "basket":
            basket = body
    if basket is None:
        raise Exception("Basket not found")
    if target_object is None:
        raise Exception("Target object not found")

    # Get basket and target positions
    target_position = target_object.position
    basket_position = basket.position
    target_radius = target_object.fixtures[0].shape.radius

    # Get the bounding box of the basket
    bottom_left = (
        basket_position[0]
        - basket_width / 2
        + thickness / 2
        + tolerance
        + target_radius,
        basket_position[1] + thickness / 2 + tolerance + target_radius,
    )
    bottom_right = (
        basket_position[0]
        + basket_width / 2
        - thickness / 2
        - tolerance
        - target_radius,
        basket_position[1] + thickness / 2 + tolerance + target_radius,
    )
    top_right = (
        basket_position[0]
        + basket_width / 2
        - thickness / 2
        + angle_shift
        - tolerance
        - target_radius,
        basket_position[1] + basket_height - thickness / 2 - tolerance - target_radius,
    )
    top_left = (
        basket_position[0]
        - basket_width / 2
        + thickness / 2
        - angle_shift
        + tolerance
        + target_radius,
        basket_position[1] + basket_height - thickness / 2 - tolerance - target_radius,
    )
    success_bounding_box = [bottom_left, bottom_right, top_right, top_left]

    # Check if the current position of the target is inside the bounding box
    if is_point_inside_polygon(
        target_position[0], target_position[1], success_bounding_box
    ):
        return True

    return False
